'2D Maze
#include "colors.inc"
option base 0
dim integer width, height, done, i
dim integer x, y, currentx, currenty, oldx, oldy
'dim string maze$(2280, 1140) length 1  '2280, 1140 is nearly the maximum that can be allocated
dim string maze$(100, 50) length 1
cls
mode 1, 16
color Indigo

'must be even
width = 98 : height = 48

'fill array
for x = 0 to width
  for y = 0 to height
    maze$(x, y) = chr$(219)
  next y
next x

'Initial start location
currentx = int(rnd * (width - 1))
currenty = int(rnd * (height - 1))

'value must be odd
if currentx mod 2 = 0 then currentx = currentx + 1
if currenty mod 2 = 0 then currenty = currenty + 1
maze$(x, y) = " "

'generate maze
done = 0
do while done = 0
  for i = 0 to 99
    oldx = currentx
    oldy = currenty

    'move in random direction
    select case int(rnd * 4)
      case 0
        if currentx + 2 < width then currentx = currentx + 2
      case 1
        if currenty + 2 < height then currenty = currenty + 2
      case 2
        if currentx - 2 > 0 then currentx = currentx - 2
      case 3
        if currenty - 2 > 0 then currenty = currenty - 2
    end select

    'if cell is unvisited, then connect it
    if maze$(currentx, currenty) = chr$(219) then
      maze$(currentx, currenty) = " "
      maze$(int((currentx + oldx) / 2), ((currenty + oldy) / 2)) = " "
    endif
  next i

  'check if all cells are visited
  done = 1
  for x = 1 to width - 1 step 2
    for y = 1 to height - 1 step 2
      if maze$(x, y) = chr$(219) then done = 0
    next y
  next x
loop

'draw maze
for y = 0 to height
  for x = 0 to width
    print maze$(x, y);
    'if maze$(x, y) = chr$(219) then
    '  pixel x, y
    'endif
  next x
  print
next y

'wait
do : loop while inkey$ = ""
cls













































